package io.burkard.cdk.services.efs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AccessPoint {

  def apply(
    internalResourceId: String,
    fileSystem: software.amazon.awscdk.services.efs.IFileSystem,
    path: Option[String] = None,
    posixUser: Option[software.amazon.awscdk.services.efs.PosixUser] = None,
    createAcl: Option[software.amazon.awscdk.services.efs.Acl] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.efs.AccessPoint =
    software.amazon.awscdk.services.efs.AccessPoint.Builder
      .create(stackCtx, internalResourceId)
      .fileSystem(fileSystem)
      .path(path.orNull)
      .posixUser(posixUser.orNull)
      .createAcl(createAcl.orNull)
      .build()
}
