package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TaskDefinitionAttributes {

  def apply(
    taskRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    networkMode: Option[software.amazon.awscdk.services.ecs.NetworkMode] = None,
    taskDefinitionArn: Option[String] = None,
    compatibility: Option[software.amazon.awscdk.services.ecs.Compatibility] = None
  ): software.amazon.awscdk.services.ecs.TaskDefinitionAttributes =
    (new software.amazon.awscdk.services.ecs.TaskDefinitionAttributes.Builder)
      .taskRole(taskRole.orNull)
      .networkMode(networkMode.orNull)
      .taskDefinitionArn(taskDefinitionArn.orNull)
      .compatibility(compatibility.orNull)
      .build()
}
