package io.burkard.cdk.services.ecs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ClusterAttributes {

  def apply(
    securityGroups: List[_ <: software.amazon.awscdk.services.ec2.ISecurityGroup],
    vpc: software.amazon.awscdk.services.ec2.IVpc,
    clusterName: String,
    hasEc2Capacity: Option[Boolean] = None,
    defaultCloudMapNamespace: Option[software.amazon.awscdk.services.servicediscovery.INamespace] = None,
    autoscalingGroup: Option[software.amazon.awscdk.services.autoscaling.IAutoScalingGroup] = None,
    clusterArn: Option[String] = None,
    executeCommandConfiguration: Option[software.amazon.awscdk.services.ecs.ExecuteCommandConfiguration] = None
  ): software.amazon.awscdk.services.ecs.ClusterAttributes =
    (new software.amazon.awscdk.services.ecs.ClusterAttributes.Builder)
      .securityGroups(securityGroups.asJava)
      .vpc(vpc)
      .clusterName(clusterName)
      .hasEc2Capacity(hasEc2Capacity.map(Boolean.box).orNull)
      .defaultCloudMapNamespace(defaultCloudMapNamespace.orNull)
      .autoscalingGroup(autoscalingGroup.orNull)
      .clusterArn(clusterArn.orNull)
      .executeCommandConfiguration(executeCommandConfiguration.orNull)
      .build()
}
