package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BottleRocketImageProps {

  def apply(
    variant: Option[software.amazon.awscdk.services.ecs.BottlerocketEcsVariant] = None,
    architecture: Option[software.amazon.awscdk.services.ec2.InstanceArchitecture] = None,
    cachedInContext: Option[Boolean] = None
  ): software.amazon.awscdk.services.ecs.BottleRocketImageProps =
    (new software.amazon.awscdk.services.ecs.BottleRocketImageProps.Builder)
      .variant(variant.orNull)
      .architecture(architecture.orNull)
      .cachedInContext(cachedInContext.map(Boolean.box).orNull)
      .build()
}
