package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object S3DestinationOptions {

  def apply(
    fileFormat: Option[software.amazon.awscdk.services.ec2.FlowLogFileFormat] = None,
    hiveCompatiblePartitions: Option[Boolean] = None,
    perHourPartition: Option[Boolean] = None
  ): software.amazon.awscdk.services.ec2.S3DestinationOptions =
    (new software.amazon.awscdk.services.ec2.S3DestinationOptions.Builder)
      .fileFormat(fileFormat.orNull)
      .hiveCompatiblePartitions(hiveCompatiblePartitions.map(Boolean.box).orNull)
      .perHourPartition(perHourPartition.map(Boolean.box).orNull)
      .build()
}
