package io.burkard.cdk.services.ec2

sealed abstract class InstanceClass(val underlying: software.amazon.awscdk.services.ec2.InstanceClass)
  extends Product
    with Serializable

object InstanceClass {
  implicit def toAws(value: InstanceClass): software.amazon.awscdk.services.ec2.InstanceClass =
    Option(value).map(_.underlying).orNull

  case object Standard3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD3)

  case object M3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M3)

  case object Standard4
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD4)

  case object M4
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M4)

  case object Standard5
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD5)

  case object M5
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M5)

  case object Standard5NvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD5_NVME_DRIVE)

  case object M5d
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M5D)

  case object Standard5Amd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD5_AMD)

  case object M5a
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M5A)

  case object Standard5AmdNvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD5_AMD_NVME_DRIVE)

  case object M5ad
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M5AD)

  case object Standard5HighPerformance
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD5_HIGH_PERFORMANCE)

  case object M5n
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M5N)

  case object Standard5NvmeDriveHighPerformance
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE)

  case object M5dn
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M5DN)

  case object Standard5HighCompute
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD5_HIGH_COMPUTE)

  case object M5zn
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M5ZN)

  case object Memory3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY3)

  case object R3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R3)

  case object Memory4
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY4)

  case object R4
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R4)

  case object Memory5
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY5)

  case object R5
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R5)

  case object Memory6Amd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY6_AMD)

  case object R6a
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R6A)

  case object Memory6Intel
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY6_INTEL)

  case object R6i
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R6I)

  case object Memory6IntelNvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY6_INTEL_NVME_DRIVE)

  case object R6id
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R6ID)

  case object Memory5HighPerformance
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY5_HIGH_PERFORMANCE)

  case object R5n
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R5N)

  case object Memory5NvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY5_NVME_DRIVE)

  case object R5d
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R5D)

  case object Memory5NvmeDriveHighPerformance
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE)

  case object R5dn
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R5DN)

  case object Memory5Amd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY5_AMD)

  case object R5a
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R5A)

  case object Memory5AmdNvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY5_AMD_NVME_DRIVE)

  case object HighMemory3tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.HIGH_MEMORY_3TB_1)

  case object U3tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.U_3TB1)

  case object HighMemory6tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.HIGH_MEMORY_6TB_1)

  case object U6tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.U_6TB1)

  case object HighMemory9tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.HIGH_MEMORY_9TB_1)

  case object U9tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.U_9TB1)

  case object HighMemory12tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.HIGH_MEMORY_12TB_1)

  case object U12tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.U_12TB1)

  case object HighMemory18tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.HIGH_MEMORY_18TB_1)

  case object U18tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.U_18TB1)

  case object HighMemory24tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.HIGH_MEMORY_24TB_1)

  case object U24tb1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.U_24TB1)

  case object R5ad
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R5AD)

  case object Memory5EbsOptimized
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY5_EBS_OPTIMIZED)

  case object R5b
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R5B)

  case object Memory6Graviton
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY6_GRAVITON)

  case object R6g
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R6G)

  case object Memory6Graviton2NvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY6_GRAVITON2_NVME_DRIVE)

  case object R6gd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.R6GD)

  case object Compute3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE3)

  case object C3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C3)

  case object Compute4
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE4)

  case object C4
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C4)

  case object Compute5
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE5)

  case object C5
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C5)

  case object Compute5NvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE5_NVME_DRIVE)

  case object C5d
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C5D)

  case object Compute5Amd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE5_AMD)

  case object C5a
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C5A)

  case object Compute5AmdNvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE5_AMD_NVME_DRIVE)

  case object C5ad
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C5AD)

  case object Compute5HighPerformance
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE5_HIGH_PERFORMANCE)

  case object C5n
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C5N)

  case object Compute6Intel
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE6_INTEL)

  case object C6i
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C6I)

  case object Compute6IntelNvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE6_INTEL_NVME_DRIVE)

  case object C6id
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C6ID)

  case object Compute6Amd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE6_AMD)

  case object C6a
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C6A)

  case object Compute6Graviton2
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE6_GRAVITON2)

  case object C6g
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C6G)

  case object Compute7Graviton3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE7_GRAVITON3)

  case object C7g
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C7G)

  case object Compute6Graviton2NvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE6_GRAVITON2_NVME_DRIVE)

  case object C6gd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C6GD)

  case object Compute6Graviton2HighNetworkBandwith
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWITH)

  case object Compute6Graviton2HighNetworkBandwidth
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWIDTH)

  case object C6gn
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.C6GN)

  case object Storage2
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STORAGE2)

  case object D2
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.D2)

  case object Storage3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STORAGE3)

  case object D3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.D3)

  case object Storage3EnhancedNetwork
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STORAGE3_ENHANCED_NETWORK)

  case object D3en
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.D3EN)

  case object StorageCompute1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STORAGE_COMPUTE_1)

  case object H1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.H1)

  case object Io3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.IO3)

  case object I3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.I3)

  case object Io3DenseNvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.IO3_DENSE_NVME_DRIVE)

  case object I3en
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.I3EN)

  case object Io4Intel
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.IO4_INTEL)

  case object I4i
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.I4I)

  case object Storage4GravitonNetworkOptimized
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STORAGE4_GRAVITON_NETWORK_OPTIMIZED)

  case object Im4gn
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.IM4GN)

  case object Storage4GravitonNetworkStorageOptimized
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED)

  case object Is4gen
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.IS4GEN)

  case object Burstable2
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.BURSTABLE2)

  case object T2
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.T2)

  case object Burstable3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.BURSTABLE3)

  case object T3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.T3)

  case object Burstable3Amd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.BURSTABLE3_AMD)

  case object T3a
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.T3A)

  case object Burstable4Graviton
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.BURSTABLE4_GRAVITON)

  case object T4g
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.T4G)

  case object MemoryIntensive1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY_INTENSIVE_1)

  case object X1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.X1)

  case object MemoryIntensive1Extended
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY_INTENSIVE_1_EXTENDED)

  case object X1e
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.X1E)

  case object MemoryIntensive2Graviton2
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY_INTENSIVE_2_GRAVITON2)

  case object X2g
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.X2G)

  case object MemoryIntensive2Graviton2NvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE)

  case object X2gd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.X2GD)

  case object MemoryIntensive2XtIntel
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY_INTENSIVE_2_XT_INTEL)

  case object X2iedn
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.X2IEDN)

  case object MemoryIntensive2Intel
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY_INTENSIVE_2_INTEL)

  case object X2idn
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.X2IDN)

  case object MemoryIntensive2XtzIntel
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MEMORY_INTENSIVE_2_XTZ_INTEL)

  case object X2iezn
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.X2IEZN)

  case object Fpga1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.FPGA1)

  case object F1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.F1)

  case object Graphics3Small
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.GRAPHICS3_SMALL)

  case object G3s
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.G3S)

  case object Graphics3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.GRAPHICS3)

  case object G3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.G3)

  case object Graphics4NvmeDriveHighPerformance
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE)

  case object G4dn
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.G4DN)

  case object Graphics4AmdNvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.GRAPHICS4_AMD_NVME_DRIVE)

  case object G4ad
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.G4AD)

  case object Graphics5
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.GRAPHICS5)

  case object G5
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.G5)

  case object Graphics5Graviton2
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.GRAPHICS5_GRAVITON2)

  case object G5g
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.G5G)

  case object Parallel2
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.PARALLEL2)

  case object P2
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.P2)

  case object Parallel3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.PARALLEL3)

  case object P3
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.P3)

  case object Parallel3NvmeDriveHighPerformance
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.PARALLEL3_NVME_DRIVE_HIGH_PERFORMANCE)

  case object P3dn
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.P3DN)

  case object Parallel4
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.PARALLEL4)

  case object P4d
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.P4D)

  case object Arm1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.ARM1)

  case object A1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.A1)

  case object Standard6Graviton
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD6_GRAVITON)

  case object M6g
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M6G)

  case object Standard6Intel
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD6_INTEL)

  case object M6i
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M6I)

  case object Standard6IntelNvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD6_INTEL_NVME_DRIVE)

  case object M6id
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M6ID)

  case object Standard6Amd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD6_AMD)

  case object M6a
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M6A)

  case object Standard6Graviton2NvmeDrive
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.STANDARD6_GRAVITON2_NVME_DRIVE)

  case object M6gd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.M6GD)

  case object HighComputeMemory1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.HIGH_COMPUTE_MEMORY1)

  case object Z1d
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.Z1D)

  case object Inference1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.INFERENCE1)

  case object Inf1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.INF1)

  case object Macintosh1Intel
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MACINTOSH1_INTEL)

  case object Mac1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.MAC1)

  case object VideoTranscoding1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.VIDEO_TRANSCODING1)

  case object Vt1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.VT1)

  case object HighPerformanceComputing6Amd
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.HIGH_PERFORMANCE_COMPUTING6_AMD)

  case object Hpc6a
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.HPC6A)

  case object DeepLearning1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.DEEP_LEARNING1)

  case object Dl1
    extends InstanceClass(software.amazon.awscdk.services.ec2.InstanceClass.DL1)
}
