package io.burkard.cdk.services.ec2

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceSnapshotOptions {

  def apply(
    deleteOnTermination: Option[Boolean] = None,
    volumeSize: Option[Number] = None,
    iops: Option[Number] = None,
    volumeType: Option[software.amazon.awscdk.services.ec2.EbsDeviceVolumeType] = None
  ): software.amazon.awscdk.services.ec2.EbsDeviceSnapshotOptions =
    (new software.amazon.awscdk.services.ec2.EbsDeviceSnapshotOptions.Builder)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .volumeSize(volumeSize.orNull)
      .iops(iops.orNull)
      .volumeType(volumeType.orNull)
      .build()
}
