package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSubnet {

  def apply(
    internalResourceId: String,
    vpcId: String,
    assignIpv6AddressOnCreation: Option[Boolean] = None,
    availabilityZoneId: Option[String] = None,
    privateDnsNameOptionsOnLaunch: Option[AnyRef] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    enableDns64: Option[Boolean] = None,
    availabilityZone: Option[String] = None,
    ipv6Native: Option[Boolean] = None,
    cidrBlock: Option[String] = None,
    outpostArn: Option[String] = None,
    ipv6CidrBlock: Option[String] = None,
    mapPublicIpOnLaunch: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnSubnet =
    software.amazon.awscdk.services.ec2.CfnSubnet.Builder
      .create(stackCtx, internalResourceId)
      .vpcId(vpcId)
      .assignIpv6AddressOnCreation(assignIpv6AddressOnCreation.map(Boolean.box).orNull)
      .availabilityZoneId(availabilityZoneId.orNull)
      .privateDnsNameOptionsOnLaunch(privateDnsNameOptionsOnLaunch.orNull)
      .tags(tags.map(_.asJava).orNull)
      .enableDns64(enableDns64.map(Boolean.box).orNull)
      .availabilityZone(availabilityZone.orNull)
      .ipv6Native(ipv6Native.map(Boolean.box).orNull)
      .cidrBlock(cidrBlock.orNull)
      .outpostArn(outpostArn.orNull)
      .ipv6CidrBlock(ipv6CidrBlock.orNull)
      .mapPublicIpOnLaunch(mapPublicIpOnLaunch.map(Boolean.box).orNull)
      .build()
}
