package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLaunchTemplate {

  def apply(
    internalResourceId: String,
    launchTemplateData: software.amazon.awscdk.services.ec2.CfnLaunchTemplate.LaunchTemplateDataProperty,
    launchTemplateName: Option[String] = None,
    tagSpecifications: Option[List[_]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnLaunchTemplate =
    software.amazon.awscdk.services.ec2.CfnLaunchTemplate.Builder
      .create(stackCtx, internalResourceId)
      .launchTemplateData(launchTemplateData)
      .launchTemplateName(launchTemplateName.orNull)
      .tagSpecifications(tagSpecifications.map(_.asJava).orNull)
      .build()
}
