package io.burkard.cdk.services.datasync

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLocationFSxOpenZFSProps {

  def apply(
    securityGroupArns: List[String],
    fsxFilesystemArn: String,
    protocol: software.amazon.awscdk.services.datasync.CfnLocationFSxOpenZFS.ProtocolProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    subdirectory: Option[String] = None
  ): software.amazon.awscdk.services.datasync.CfnLocationFSxOpenZFSProps =
    (new software.amazon.awscdk.services.datasync.CfnLocationFSxOpenZFSProps.Builder)
      .securityGroupArns(securityGroupArns.asJava)
      .fsxFilesystemArn(fsxFilesystemArn)
      .protocol(protocol)
      .tags(tags.map(_.asJava).orNull)
      .subdirectory(subdirectory.orNull)
      .build()
}
