package io.burkard.cdk.services.datasync

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLocationFSxONTAPProps {

  def apply(
    securityGroupArns: List[String],
    storageVirtualMachineArn: String,
    protocol: software.amazon.awscdk.services.datasync.CfnLocationFSxONTAP.ProtocolProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    subdirectory: Option[String] = None
  ): software.amazon.awscdk.services.datasync.CfnLocationFSxONTAPProps =
    (new software.amazon.awscdk.services.datasync.CfnLocationFSxONTAPProps.Builder)
      .securityGroupArns(securityGroupArns.asJava)
      .storageVirtualMachineArn(storageVirtualMachineArn)
      .protocol(protocol)
      .tags(tags.map(_.asJava).orNull)
      .subdirectory(subdirectory.orNull)
      .build()
}
