package io.burkard.cdk.services.connect

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTaskTemplateProps {

  def apply(
    instanceArn: String,
    name: Option[String] = None,
    defaults: Option[List[_]] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    clientToken: Option[String] = None,
    status: Option[String] = None,
    fields: Option[List[_]] = None,
    constraints: Option[AnyRef] = None,
    contactFlowArn: Option[String] = None
  ): software.amazon.awscdk.services.connect.CfnTaskTemplateProps =
    (new software.amazon.awscdk.services.connect.CfnTaskTemplateProps.Builder)
      .instanceArn(instanceArn)
      .name(name.orNull)
      .defaults(defaults.map(_.asJava).orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .clientToken(clientToken.orNull)
      .status(status.orNull)
      .fields(fields.map(_.asJava).orNull)
      .constraints(constraints.orNull)
      .contactFlowArn(contactFlowArn.orNull)
      .build()
}
