package io.burkard.cdk.services.cognito

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UserPoolResourceServerProps {

  def apply(
    userPool: software.amazon.awscdk.services.cognito.IUserPool,
    scopes: Option[List[_ <: software.amazon.awscdk.services.cognito.ResourceServerScope]] = None,
    identifier: Option[String] = None,
    userPoolResourceServerName: Option[String] = None
  ): software.amazon.awscdk.services.cognito.UserPoolResourceServerProps =
    (new software.amazon.awscdk.services.cognito.UserPoolResourceServerProps.Builder)
      .userPool(userPool)
      .scopes(scopes.map(_.asJava).orNull)
      .identifier(identifier.orNull)
      .userPoolResourceServerName(userPoolResourceServerName.orNull)
      .build()
}
