package io.burkard.cdk.services.cognito

sealed abstract class OidcAttributeRequestMethod(val underlying: software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod)
  extends Product
    with Serializable

object OidcAttributeRequestMethod {
  implicit def toAws(value: OidcAttributeRequestMethod): software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod =
    Option(value).map(_.underlying).orNull

  case object Get
    extends OidcAttributeRequestMethod(software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod.GET)

  case object Post
    extends OidcAttributeRequestMethod(software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod.POST)
}
