package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AuthFlow {

  def apply(
    custom: Option[Boolean] = None,
    userPassword: Option[Boolean] = None,
    userSrp: Option[Boolean] = None,
    adminUserPassword: Option[Boolean] = None
  ): software.amazon.awscdk.services.cognito.AuthFlow =
    (new software.amazon.awscdk.services.cognito.AuthFlow.Builder)
      .custom(custom.map(Boolean.box).orNull)
      .userPassword(userPassword.map(Boolean.box).orNull)
      .userSrp(userSrp.map(Boolean.box).orNull)
      .adminUserPassword(adminUserPassword.map(Boolean.box).orNull)
      .build()
}
