package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CustomLambdaDeploymentConfig {

  def apply(
    internalResourceId: String,
    `type`: software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfigType,
    interval: software.amazon.awscdk.Duration,
    percentage: Number,
    deploymentConfigName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfig =
    software.amazon.awscdk.services.codedeploy.CustomLambdaDeploymentConfig.Builder
      .create(stackCtx, internalResourceId)
      .`type`(`type`)
      .interval(interval)
      .percentage(percentage)
      .deploymentConfigName(deploymentConfigName.orNull)
      .build()
}
