package io.burkard.cdk.services.codebuild.cfnProject

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object VpcConfigProperty {

  def apply(
    vpcId: Option[String] = None,
    subnets: Option[List[String]] = None,
    securityGroupIds: Option[List[String]] = None
  ): software.amazon.awscdk.services.codebuild.CfnProject.VpcConfigProperty =
    (new software.amazon.awscdk.services.codebuild.CfnProject.VpcConfigProperty.Builder)
      .vpcId(vpcId.orNull)
      .subnets(subnets.map(_.asJava).orNull)
      .securityGroupIds(securityGroupIds.map(_.asJava).orNull)
      .build()
}
