package io.burkard.cdk.services.cloudtrail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEventDataStoreProps {

  def apply(
    organizationEnabled: Option[Boolean] = None,
    name: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    retentionPeriod: Option[Number] = None,
    advancedEventSelectors: Option[List[_]] = None,
    multiRegionEnabled: Option[Boolean] = None,
    terminationProtectionEnabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps =
    (new software.amazon.awscdk.services.cloudtrail.CfnEventDataStoreProps.Builder)
      .organizationEnabled(organizationEnabled.map(Boolean.box).orNull)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .retentionPeriod(retentionPeriod.orNull)
      .advancedEventSelectors(advancedEventSelectors.map(_.asJava).orNull)
      .multiRegionEnabled(multiRegionEnabled.map(Boolean.box).orNull)
      .terminationProtectionEnabled(terminationProtectionEnabled.map(Boolean.box).orNull)
      .build()
}
