package io.burkard.cdk.services.cloudfront.cfnDistribution

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CustomErrorResponseProperty {

  def apply(
    errorCode: Number,
    responsePagePath: Option[String] = None,
    errorCachingMinTtl: Option[Number] = None,
    responseCode: Option[Number] = None
  ): software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomErrorResponseProperty =
    (new software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomErrorResponseProperty.Builder)
      .errorCode(errorCode)
      .responsePagePath(responsePagePath.orNull)
      .errorCachingMinTtl(errorCachingMinTtl.orNull)
      .responseCode(responseCode.orNull)
      .build()
}
