package io.burkard.cdk.services.ce

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAnomalyMonitor {

  def apply(
    internalResourceId: String,
    monitorType: String,
    monitorName: String,
    monitorDimension: Option[String] = None,
    resourceTags: Option[List[_]] = None,
    monitorSpecification: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ce.CfnAnomalyMonitor =
    software.amazon.awscdk.services.ce.CfnAnomalyMonitor.Builder
      .create(stackCtx, internalResourceId)
      .monitorType(monitorType)
      .monitorName(monitorName)
      .monitorDimension(monitorDimension.orNull)
      .resourceTags(resourceTags.map(_.asJava).orNull)
      .monitorSpecification(monitorSpecification.orNull)
      .build()
}
