package io.burkard.cdk.services.billingconductor

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBillingGroup {

  def apply(
    internalResourceId: String,
    name: String,
    primaryAccountId: String,
    accountGrouping: software.amazon.awscdk.services.billingconductor.CfnBillingGroup.AccountGroupingProperty,
    computationPreference: software.amazon.awscdk.services.billingconductor.CfnBillingGroup.ComputationPreferenceProperty,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.billingconductor.CfnBillingGroup =
    software.amazon.awscdk.services.billingconductor.CfnBillingGroup.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .primaryAccountId(primaryAccountId)
      .accountGrouping(accountGrouping)
      .computationPreference(computationPreference)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
