package io.burkard.cdk.services.backup

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LockConfiguration {

  def apply(
    minRetention: software.amazon.awscdk.Duration,
    changeableFor: Option[software.amazon.awscdk.Duration] = None,
    maxRetention: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.backup.LockConfiguration =
    (new software.amazon.awscdk.services.backup.LockConfiguration.Builder)
      .minRetention(minRetention)
      .changeableFor(changeableFor.orNull)
      .maxRetention(maxRetention.orNull)
      .build()
}
