package io.burkard.cdk.services.autoscaling.cfnScalingPolicy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TargetTrackingConfigurationProperty {

  def apply(
    targetValue: Number,
    customizedMetricSpecification: Option[software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.CustomizedMetricSpecificationProperty] = None,
    predefinedMetricSpecification: Option[software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.PredefinedMetricSpecificationProperty] = None,
    disableScaleIn: Option[Boolean] = None
  ): software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.TargetTrackingConfigurationProperty =
    (new software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.TargetTrackingConfigurationProperty.Builder)
      .targetValue(targetValue)
      .customizedMetricSpecification(customizedMetricSpecification.orNull)
      .predefinedMetricSpecification(predefinedMetricSpecification.orNull)
      .disableScaleIn(disableScaleIn.map(Boolean.box).orNull)
      .build()
}
