package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LaunchTemplateOverrides {

  def apply(
    instanceType: software.amazon.awscdk.services.ec2.InstanceType,
    launchTemplate: Option[software.amazon.awscdk.services.ec2.ILaunchTemplate] = None,
    weightedCapacity: Option[Number] = None
  ): software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides =
    (new software.amazon.awscdk.services.autoscaling.LaunchTemplateOverrides.Builder)
      .instanceType(instanceType)
      .launchTemplate(launchTemplate.orNull)
      .weightedCapacity(weightedCapacity.orNull)
      .build()
}
