package io.burkard.cdk.services.appsync

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFunctionConfigurationProps {

  def apply(
    name: String,
    functionVersion: String,
    dataSourceName: String,
    apiId: String,
    responseMappingTemplate: Option[String] = None,
    requestMappingTemplate: Option[String] = None,
    description: Option[String] = None,
    syncConfig: Option[software.amazon.awscdk.services.appsync.CfnFunctionConfiguration.SyncConfigProperty] = None,
    requestMappingTemplateS3Location: Option[String] = None,
    maxBatchSize: Option[Number] = None,
    responseMappingTemplateS3Location: Option[String] = None
  ): software.amazon.awscdk.services.appsync.CfnFunctionConfigurationProps =
    (new software.amazon.awscdk.services.appsync.CfnFunctionConfigurationProps.Builder)
      .name(name)
      .functionVersion(functionVersion)
      .dataSourceName(dataSourceName)
      .apiId(apiId)
      .responseMappingTemplate(responseMappingTemplate.orNull)
      .requestMappingTemplate(requestMappingTemplate.orNull)
      .description(description.orNull)
      .syncConfig(syncConfig.orNull)
      .requestMappingTemplateS3Location(requestMappingTemplateS3Location.orNull)
      .maxBatchSize(maxBatchSize.orNull)
      .responseMappingTemplateS3Location(responseMappingTemplateS3Location.orNull)
      .build()
}
