package io.burkard.cdk.services.appmesh.cfnVirtualNode

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AwsCloudMapServiceDiscoveryProperty {

  def apply(
    serviceName: String,
    namespaceName: String,
    attributes: Option[List[_]] = None,
    ipPreference: Option[String] = None
  ): software.amazon.awscdk.services.appmesh.CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty =
    (new software.amazon.awscdk.services.appmesh.CfnVirtualNode.AwsCloudMapServiceDiscoveryProperty.Builder)
      .serviceName(serviceName)
      .namespaceName(namespaceName)
      .attributes(attributes.map(_.asJava).orNull)
      .ipPreference(ipPreference.orNull)
      .build()
}
