package io.burkard.cdk.services.appmesh

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object HttpRetryPolicy {

  def apply(
    retryAttempts: Number,
    retryTimeout: software.amazon.awscdk.Duration,
    tcpRetryEvents: Option[List[_ <: software.amazon.awscdk.services.appmesh.TcpRetryEvent]] = None,
    httpRetryEvents: Option[List[_ <: software.amazon.awscdk.services.appmesh.HttpRetryEvent]] = None
  ): software.amazon.awscdk.services.appmesh.HttpRetryPolicy =
    (new software.amazon.awscdk.services.appmesh.HttpRetryPolicy.Builder)
      .retryAttempts(retryAttempts)
      .retryTimeout(retryTimeout)
      .tcpRetryEvents(tcpRetryEvents.map(_.asJava).orNull)
      .httpRetryEvents(httpRetryEvents.map(_.asJava).orNull)
      .build()
}
