package io.burkard.cdk.services.applicationautoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScalableTargetProps {

  def apply(
    scalableDimension: String,
    resourceId: String,
    maxCapacity: Number,
    serviceNamespace: software.amazon.awscdk.services.applicationautoscaling.ServiceNamespace,
    minCapacity: Number,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None
  ): software.amazon.awscdk.services.applicationautoscaling.ScalableTargetProps =
    (new software.amazon.awscdk.services.applicationautoscaling.ScalableTargetProps.Builder)
      .scalableDimension(scalableDimension)
      .resourceId(resourceId)
      .maxCapacity(maxCapacity)
      .serviceNamespace(serviceNamespace)
      .minCapacity(minCapacity)
      .role(role.orNull)
      .build()
}
