package io.burkard.cdk.services.appflow.cfnFlow

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScheduledTriggerPropertiesProperty {

  def apply(
    scheduleExpression: String,
    dataPullMode: Option[String] = None,
    scheduleStartTime: Option[Number] = None,
    scheduleOffset: Option[Number] = None,
    flowErrorDeactivationThreshold: Option[Number] = None,
    firstExecutionFrom: Option[Number] = None,
    scheduleEndTime: Option[Number] = None,
    timeZone: Option[String] = None
  ): software.amazon.awscdk.services.appflow.CfnFlow.ScheduledTriggerPropertiesProperty =
    (new software.amazon.awscdk.services.appflow.CfnFlow.ScheduledTriggerPropertiesProperty.Builder)
      .scheduleExpression(scheduleExpression)
      .dataPullMode(dataPullMode.orNull)
      .scheduleStartTime(scheduleStartTime.orNull)
      .scheduleOffset(scheduleOffset.orNull)
      .flowErrorDeactivationThreshold(flowErrorDeactivationThreshold.orNull)
      .firstExecutionFrom(firstExecutionFrom.orNull)
      .scheduleEndTime(scheduleEndTime.orNull)
      .timeZone(timeZone.orNull)
      .build()
}
