package io.burkard.cdk.services.appflow.cfnFlow

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SAPODataDestinationPropertiesProperty {

  def apply(
    objectPath: String,
    successResponseHandlingConfig: Option[software.amazon.awscdk.services.appflow.CfnFlow.SuccessResponseHandlingConfigProperty] = None,
    writeOperationType: Option[String] = None,
    idFieldNames: Option[List[String]] = None,
    errorHandlingConfig: Option[software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty] = None
  ): software.amazon.awscdk.services.appflow.CfnFlow.SAPODataDestinationPropertiesProperty =
    (new software.amazon.awscdk.services.appflow.CfnFlow.SAPODataDestinationPropertiesProperty.Builder)
      .objectPath(objectPath)
      .successResponseHandlingConfig(successResponseHandlingConfig.orNull)
      .writeOperationType(writeOperationType.orNull)
      .idFieldNames(idFieldNames.map(_.asJava).orNull)
      .errorHandlingConfig(errorHandlingConfig.orNull)
      .build()
}
