package io.burkard.cdk.services.apigateway.cfnStage

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CanarySettingProperty {

  def apply(
    deploymentId: Option[String] = None,
    stageVariableOverrides: Option[Map[String, String]] = None,
    useStageCache: Option[Boolean] = None,
    percentTraffic: Option[Number] = None
  ): software.amazon.awscdk.services.apigateway.CfnStage.CanarySettingProperty =
    (new software.amazon.awscdk.services.apigateway.CfnStage.CanarySettingProperty.Builder)
      .deploymentId(deploymentId.orNull)
      .stageVariableOverrides(stageVariableOverrides.map(_.asJava).orNull)
      .useStageCache(useStageCache.map(Boolean.box).orNull)
      .percentTraffic(percentTraffic.orNull)
      .build()
}
