package io.burkard.cdk.services.apigateway.cfnDeployment

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CanarySettingProperty {

  def apply(
    stageVariableOverrides: Option[Map[String, String]] = None,
    useStageCache: Option[Boolean] = None,
    percentTraffic: Option[Number] = None
  ): software.amazon.awscdk.services.apigateway.CfnDeployment.CanarySettingProperty =
    (new software.amazon.awscdk.services.apigateway.CfnDeployment.CanarySettingProperty.Builder)
      .stageVariableOverrides(stageVariableOverrides.map(_.asJava).orNull)
      .useStageCache(useStageCache.map(Boolean.box).orNull)
      .percentTraffic(percentTraffic.orNull)
      .build()
}
