package io.burkard.cdk.services.apigateway

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RequestValidatorProps {

  def apply(
    restApi: software.amazon.awscdk.services.apigateway.IRestApi,
    requestValidatorName: Option[String] = None,
    validateRequestBody: Option[Boolean] = None,
    validateRequestParameters: Option[Boolean] = None
  ): software.amazon.awscdk.services.apigateway.RequestValidatorProps =
    (new software.amazon.awscdk.services.apigateway.RequestValidatorProps.Builder)
      .restApi(restApi)
      .requestValidatorName(requestValidatorName.orNull)
      .validateRequestBody(validateRequestBody.map(Boolean.box).orNull)
      .validateRequestParameters(validateRequestParameters.map(Boolean.box).orNull)
      .build()
}
