package io.burkard.cdk.cxapi

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudAssembly {

  def apply(
    directory: String,
    skipEnumCheck: Option[Boolean] = None,
    skipVersionCheck: Option[Boolean] = None
  ): software.amazon.awscdk.cxapi.CloudAssembly =
    software.amazon.awscdk.cxapi.CloudAssembly.Builder
      .create(directory)
      .skipEnumCheck(skipEnumCheck.map(Boolean.box).orNull)
      .skipVersionCheck(skipVersionCheck.map(Boolean.box).orNull)
      .build()
}
