package io.burkard.cdk.cloudassembly.schema

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DestroyCommand {

  def apply(
    args: Option[software.amazon.awscdk.cloudassembly.schema.DestroyOptions] = None,
    enabled: Option[Boolean] = None,
    expectedMessage: Option[String] = None,
    expectError: Option[Boolean] = None
  ): software.amazon.awscdk.cloudassembly.schema.DestroyCommand =
    (new software.amazon.awscdk.cloudassembly.schema.DestroyCommand.Builder)
      .args(args.orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .expectedMessage(expectedMessage.orNull)
      .expectError(expectError.map(Boolean.box).orNull)
      .build()
}
