package io.burkard.cdk.cloudassembly.schema

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DefaultCdkOptions {

  def apply(
    staging: Option[Boolean] = None,
    strict: Option[Boolean] = None,
    assetMetadata: Option[Boolean] = None,
    trace: Option[Boolean] = None,
    verbose: Option[Boolean] = None,
    json: Option[Boolean] = None,
    all: Option[Boolean] = None,
    context: Option[Map[String, String]] = None,
    ec2Creds: Option[Boolean] = None,
    color: Option[Boolean] = None,
    stacks: Option[List[String]] = None,
    pathMetadata: Option[Boolean] = None,
    caBundlePath: Option[String] = None,
    debug: Option[Boolean] = None,
    profile: Option[String] = None,
    versionReporting: Option[Boolean] = None,
    ignoreErrors: Option[Boolean] = None,
    roleArn: Option[String] = None,
    proxy: Option[String] = None,
    app: Option[String] = None,
    output: Option[String] = None,
    notices: Option[Boolean] = None,
    lookups: Option[Boolean] = None
  ): software.amazon.awscdk.cloudassembly.schema.DefaultCdkOptions =
    (new software.amazon.awscdk.cloudassembly.schema.DefaultCdkOptions.Builder)
      .staging(staging.map(Boolean.box).orNull)
      .strict(strict.map(Boolean.box).orNull)
      .assetMetadata(assetMetadata.map(Boolean.box).orNull)
      .trace(trace.map(Boolean.box).orNull)
      .verbose(verbose.map(Boolean.box).orNull)
      .json(json.map(Boolean.box).orNull)
      .all(all.map(Boolean.box).orNull)
      .context(context.map(_.asJava).orNull)
      .ec2Creds(ec2Creds.map(Boolean.box).orNull)
      .color(color.map(Boolean.box).orNull)
      .stacks(stacks.map(_.asJava).orNull)
      .pathMetadata(pathMetadata.map(Boolean.box).orNull)
      .caBundlePath(caBundlePath.orNull)
      .debug(debug.map(Boolean.box).orNull)
      .profile(profile.orNull)
      .versionReporting(versionReporting.map(Boolean.box).orNull)
      .ignoreErrors(ignoreErrors.map(Boolean.box).orNull)
      .roleArn(roleArn.orNull)
      .proxy(proxy.orNull)
      .app(app.orNull)
      .output(output.orNull)
      .notices(notices.map(Boolean.box).orNull)
      .lookups(lookups.map(Boolean.box).orNull)
      .build()
}
