package io.burkard.cdk.services.stepfunctions.tasks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TransformOutput {

  def apply(
    s3OutputPath: String,
    accept: Option[String] = None,
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    assembleWith: Option[software.amazon.awscdk.services.stepfunctions.tasks.AssembleWith] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput =
    (new software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput.Builder)
      .s3OutputPath(s3OutputPath)
      .accept(accept.orNull)
      .encryptionKey(encryptionKey.orNull)
      .assembleWith(assembleWith.orNull)
      .build()
}
