package io.burkard.cdk.services.servicediscovery

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPublicDnsNamespaceProps {

  def apply(
    name: String,
    properties: Option[software.amazon.awscdk.services.servicediscovery.CfnPublicDnsNamespace.PropertiesProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  ): software.amazon.awscdk.services.servicediscovery.CfnPublicDnsNamespaceProps =
    (new software.amazon.awscdk.services.servicediscovery.CfnPublicDnsNamespaceProps.Builder)
      .name(name)
      .properties(properties.orNull)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
