package io.burkard.cdk.services.servicecatalog

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CloudFormationProductProps {

  def apply(
    productVersions: List[_ <: software.amazon.awscdk.services.servicecatalog.CloudFormationProductVersion],
    productName: String,
    owner: String,
    supportEmail: Option[String] = None,
    supportUrl: Option[String] = None,
    messageLanguage: Option[software.amazon.awscdk.services.servicecatalog.MessageLanguage] = None,
    description: Option[String] = None,
    supportDescription: Option[String] = None,
    distributor: Option[String] = None,
    replaceProductVersionIds: Option[Boolean] = None,
    tagOptions: Option[software.amazon.awscdk.services.servicecatalog.TagOptions] = None
  ): software.amazon.awscdk.services.servicecatalog.CloudFormationProductProps =
    (new software.amazon.awscdk.services.servicecatalog.CloudFormationProductProps.Builder)
      .productVersions(productVersions.asJava)
      .productName(productName)
      .owner(owner)
      .supportEmail(supportEmail.orNull)
      .supportUrl(supportUrl.orNull)
      .messageLanguage(messageLanguage.orNull)
      .description(description.orNull)
      .supportDescription(supportDescription.orNull)
      .distributor(distributor.orNull)
      .replaceProductVersionIds(replaceProductVersionIds.map(Boolean.box).orNull)
      .tagOptions(tagOptions.orNull)
      .build()
}
