package io.burkard.cdk.services.s3.cfnBucket

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ServerSideEncryptionRuleProperty {

  def apply(
    bucketKeyEnabled: Option[Boolean] = None,
    serverSideEncryptionByDefault: Option[software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionByDefaultProperty] = None
  ): software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionRuleProperty =
    (new software.amazon.awscdk.services.s3.CfnBucket.ServerSideEncryptionRuleProperty.Builder)
      .bucketKeyEnabled(bucketKeyEnabled.map(Boolean.box).orNull)
      .serverSideEncryptionByDefault(serverSideEncryptionByDefault.orNull)
      .build()
}
