package io.burkard.cdk.services.resiliencehub

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnAppProps {

  def apply(
    name: String,
    resourceMappings: List[_],
    appTemplateBody: String,
    resiliencyPolicyArn: Option[String] = None,
    appAssessmentSchedule: Option[String] = None,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.resiliencehub.CfnAppProps =
    (new software.amazon.awscdk.services.resiliencehub.CfnAppProps.Builder)
      .name(name)
      .resourceMappings(resourceMappings.asJava)
      .appTemplateBody(appTemplateBody)
      .resiliencyPolicyArn(resiliencyPolicyArn.orNull)
      .appAssessmentSchedule(appAssessmentSchedule.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
