package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnBaiduChannelProps {

  def apply(
    secretKey: String,
    applicationId: String,
    apiKey: String,
    enabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.pinpoint.CfnBaiduChannelProps =
    (new software.amazon.awscdk.services.pinpoint.CfnBaiduChannelProps.Builder)
      .secretKey(secretKey)
      .applicationId(applicationId)
      .apiKey(apiKey)
      .enabled(enabled.map(Boolean.box).orNull)
      .build()
}
