package io.burkard.cdk.services.personalize

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSolution {

  def apply(
    internalResourceId: String,
    name: String,
    datasetGroupArn: String,
    eventType: Option[String] = None,
    recipeArn: Option[String] = None,
    performHpo: Option[Boolean] = None,
    performAutoMl: Option[Boolean] = None,
    solutionConfig: Option[software.amazon.awscdk.services.personalize.CfnSolution.SolutionConfigProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.personalize.CfnSolution =
    software.amazon.awscdk.services.personalize.CfnSolution.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .datasetGroupArn(datasetGroupArn)
      .eventType(eventType.orNull)
      .recipeArn(recipeArn.orNull)
      .performHpo(performHpo.map(Boolean.box).orNull)
      .performAutoMl(performAutoMl.map(Boolean.box).orNull)
      .solutionConfig(solutionConfig.orNull)
      .build()
}
