package io.burkard.cdk.services.msk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConfiguration {

  def apply(
    internalResourceId: String,
    name: String,
    serverProperties: String,
    description: Option[String] = None,
    kafkaVersionsList: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.msk.CfnConfiguration =
    software.amazon.awscdk.services.msk.CfnConfiguration.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .serverProperties(serverProperties)
      .description(description.orNull)
      .kafkaVersionsList(kafkaVersionsList.map(_.asJava).orNull)
      .build()
}
