package io.burkard.cdk.services.lambda.eventsources

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BaseStreamEventSourceProps {

  def apply(
    startingPosition: software.amazon.awscdk.services.lambda.StartingPosition,
    enabled: Option[Boolean] = None,
    batchSize: Option[Number] = None,
    maxBatchingWindow: Option[software.amazon.awscdk.Duration] = None
  ): software.amazon.awscdk.services.lambda.eventsources.BaseStreamEventSourceProps =
    (new software.amazon.awscdk.services.lambda.eventsources.BaseStreamEventSourceProps.Builder)
      .startingPosition(startingPosition)
      .enabled(enabled.map(Boolean.box).orNull)
      .batchSize(batchSize.orNull)
      .maxBatchingWindow(maxBatchingWindow.orNull)
      .build()
}
