package io.burkard.cdk.services.iottwinmaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWorkspaceProps {

  def apply(
    workspaceId: String,
    role: String,
    s3Location: String,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.iottwinmaker.CfnWorkspaceProps =
    (new software.amazon.awscdk.services.iottwinmaker.CfnWorkspaceProps.Builder)
      .workspaceId(workspaceId)
      .role(role)
      .s3Location(s3Location)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
