package io.burkard.cdk.services.iottwinmaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnComponentTypeProps {

  def apply(
    workspaceId: String,
    componentTypeId: String,
    extendsFrom: Option[List[String]] = None,
    isSingleton: Option[Boolean] = None,
    propertyDefinitions: Option[Map[String, _]] = None,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    functions: Option[Map[String, _]] = None
  ): software.amazon.awscdk.services.iottwinmaker.CfnComponentTypeProps =
    (new software.amazon.awscdk.services.iottwinmaker.CfnComponentTypeProps.Builder)
      .workspaceId(workspaceId)
      .componentTypeId(componentTypeId)
      .extendsFrom(extendsFrom.map(_.asJava).orNull)
      .isSingleton(isSingleton.map(Boolean.box).orNull)
      .propertyDefinitions(propertyDefinitions.map(_.asJava).orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .functions(functions.map(_.asJava).orNull)
      .build()
}
