package io.burkard.cdk.services.iotfleethub

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplicationProps {

  def apply(
    roleArn: String,
    applicationName: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    applicationDescription: Option[String] = None
  ): software.amazon.awscdk.services.iotfleethub.CfnApplicationProps =
    (new software.amazon.awscdk.services.iotfleethub.CfnApplicationProps.Builder)
      .roleArn(roleArn)
      .applicationName(applicationName)
      .tags(tags.map(_.asJava).orNull)
      .applicationDescription(applicationDescription.orNull)
      .build()
}
