package io.burkard.cdk.services.iot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRoleAlias {

  def apply(
    internalResourceId: String,
    roleArn: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    credentialDurationSeconds: Option[Number] = None,
    roleAlias: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iot.CfnRoleAlias =
    software.amazon.awscdk.services.iot.CfnRoleAlias.Builder
      .create(stackCtx, internalResourceId)
      .roleArn(roleArn)
      .tags(tags.map(_.asJava).orNull)
      .credentialDurationSeconds(credentialDurationSeconds.orNull)
      .roleAlias(roleAlias.orNull)
      .build()
}
