package io.burkard.cdk.services.evidently

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLaunchProps {

  def apply(
    name: String,
    project: String,
    groups: List[_],
    scheduledSplitsConfig: List[_],
    metricMonitors: Option[List[_]] = None,
    executionStatus: Option[software.amazon.awscdk.services.evidently.CfnLaunch.ExecutionStatusObjectProperty] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    randomizationSalt: Option[String] = None
  ): software.amazon.awscdk.services.evidently.CfnLaunchProps =
    (new software.amazon.awscdk.services.evidently.CfnLaunchProps.Builder)
      .name(name)
      .project(project)
      .groups(groups.asJava)
      .scheduledSplitsConfig(scheduledSplitsConfig.asJava)
      .metricMonitors(metricMonitors.map(_.asJava).orNull)
      .executionStatus(executionStatus.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .randomizationSalt(randomizationSalt.orNull)
      .build()
}
